% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_types.R
\name{eg_read_file}
\alias{eg_read_file}
\alias{eg_read_csv}
\alias{eg_read_delim}
\alias{eg_read_sas}
\alias{eg_read_xpt}
\alias{eg_read_stata}
\alias{eg_read_spss}
\alias{eg_read_excel}
\alias{eg_read_rds}
\title{Read Data Files from Egnyte}
\usage{
eg_read_csv(path, ...)

eg_read_delim(path, delim = "\\t", ...)

eg_read_sas(path, ...)

eg_read_xpt(path, ...)

eg_read_stata(path, ...)

eg_read_spss(path, ...)

eg_read_excel(path, sheet = NULL, ...)

eg_read_rds(path)
}
\arguments{
\item{path}{The Egnyte path to the file (e.g., "/Shared/Data/myfile.csv").}

\item{...}{Additional arguments passed to the underlying read function.}

\item{delim}{The field delimiter. Defaults to tab (\code{"\\t"}).}

\item{sheet}{Sheet to read. Either a string (sheet name) or an integer
(sheet position). Defaults to the first sheet.}
}
\value{
\itemize{
\item For tabular data: A tibble (or data frame for RDS files containing
data frames).
\item For RDS files: The R object stored in the file.
}

Haven-based readers (\code{eg_read_sas()}, \code{eg_read_xpt()}, \code{eg_read_stata()},
\code{eg_read_spss()}) return tibbles with labelled columns preserving variable
labels and formats from the source file.
}
\description{
These functions download data files from Egnyte and read them into R using
the appropriate package. Each function is a thin wrapper that handles the
file transfer, then delegates to the underlying reader.
}
\details{
Each function requires an optional package to be installed:\tabular{lll}{
   Function \tab Package \tab Underlying Function \cr
   \code{eg_read_csv()} \tab readr \tab \code{\link[readr:read_delim]{readr::read_csv()}} \cr
   \code{eg_read_delim()} \tab readr \tab \code{\link[readr:read_delim]{readr::read_delim()}} \cr
   \code{eg_read_excel()} \tab readxl \tab \code{\link[readxl:read_excel]{readxl::read_excel()}} \cr
   \code{eg_read_sas()} \tab haven \tab \code{\link[haven:read_sas]{haven::read_sas()}} \cr
   \code{eg_read_xpt()} \tab haven \tab \code{\link[haven:read_xpt]{haven::read_xpt()}} \cr
   \code{eg_read_stata()} \tab haven \tab \code{\link[haven:read_dta]{haven::read_dta()}} \cr
   \code{eg_read_spss()} \tab haven \tab \code{\link[haven:read_spss]{haven::read_sav()}} \cr
   \code{eg_read_rds()} \tab (base R) \tab \code{\link[=readRDS]{readRDS()}} \cr
}


All arguments passed through \code{...} are forwarded to the underlying function,
so you can use any options those functions support (e.g., \code{col_types} for
readr functions, \code{encoding} for haven functions).
}
\examples{
\dontrun{
# CSV files
df <- eg_read_csv("/Shared/Data/mydata.csv")
df <- eg_read_csv("/Shared/Data/mydata.csv", col_types = "ccn")

# Delimited files
df <- eg_read_delim("/Shared/Data/mydata.txt")
df <- eg_read_delim("/Shared/Data/mydata.txt", delim = "|")

# Excel files
df <- eg_read_excel("/Shared/Data/workbook.xlsx")
df <- eg_read_excel("/Shared/Data/workbook.xlsx", sheet = "Summary")

# SAS files
df <- eg_read_sas("/Shared/Data/mydata.sas7bdat")
df <- eg_read_xpt("/Shared/Data/mydata.xpt")

# Stata files
df <- eg_read_stata("/Shared/Data/mydata.dta")

# SPSS files
df <- eg_read_spss("/Shared/Data/mydata.sav")

# RDS files (any R object)
obj <- eg_read_rds("/Shared/Data/model.rds")
}

}
\seealso{
\itemize{
\item \code{\link[=eg_read]{eg_read()}} for downloading raw files without parsing
\item \link{eg_write_file} for writing data files to Egnyte
}
}
