% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{e_matrix_corner}
\alias{e_matrix_corner}
\title{Fill Matrix Axis Corner}
\usage{
e_matrix_corner(
  e,
  coord = c(-1, -1),
  value,
  mergeCells = TRUE,
  coordClamp = FALSE,
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{coord}{corner cell coordinate location}

\item{value}{text to display in corner cell}

\item{mergeCells}{whether the body cells and corner cells can be merged}

\item{coordClamp}{determines whether null values can be used to indicate an entire row/column}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
helper function for adding data to the corner of matrix
}
\examples{

df <- data.frame("Class" = rep(c("Class1", "Class2", "Class3"),each = 3),
"Grade" = c("Grade1","Grade2", "Grade3"),
"A" = sample(1:10, 9),
"B" = sample(1:10,9))

df |> e_charts() |> e_matrix(xAxis = "Class", yAxis = "Grade") |>
e_matrix_parent(value = "Primary", children = c("Class1", "Class2")) |>
e_matrix_parent(value = "High", children = "Class3") |>
e_matrix_corner(value = "All School",
label = list(fontSize = 24, color = "#555", position = "inside"))

}
\seealso{
\href{https://echarts.apache.org/en/option.html#matrix.corner}{Additional arguments}
}
