% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{e_annotations}
\alias{e_annotations}
\title{Add annotations to a chart}
\usage{
e_annotations(
  e,
  annotations,
  .facet = NULL,
  legend = TRUE,
  name = "Annotations",
  legend_color = "#738DE4",
  default_color = "#738DE4",
  draggable = TRUE
)
}
\arguments{
\item{e}{An echarts4r object}

\item{annotations}{list of annotations to plot}

\item{.facet}{integer; facet's index. Only needed for faceted plots. Defaults to first plot.
panel.}

\item{legend}{Whether to add annotations to legend.}

\item{name}{name of the legend}

\item{legend_color}{color of the legend box}

\item{default_color}{color of all SVG elements, unless specified in each
style. It colors text, line, arrow, and rectable outline.}

\item{draggable}{booleon; if TRUE, annotations can be dragged by the user}
}
\description{
Apache ECharts does not include a native annotation system. This is a custom
function that creates annotations using SVG. This currently only works in a
'cartesian2d' coordinate system.

Each annotation must be in a list with an x, y, and text. Styling can be
added - see @details. Because they are SVG, it takes SVG arguments, not
ECharts arguments for styling.

In Shiny, to output an annotation position after dragging the box, use
\code{input$id_dragged_annotation} or see \link{echarts4r-shiny}. This
captures the annotation parameters - not any of the styles.
}
\details{
annotations can take the following styles to change the defaults. To
  remove any element use "none".

- \strong{rectStyle} Styles the annotation box. It also takes \strong{shape} that uses \href{https://echarts.apache.org/en/option.html#graphic.elements-rect.shape}{echarts graphic.elements-rect.shape attributes} that controls rectangle width,  height and corner radius.

- \strong{textStyle}, Styles the annotation text. This supports limited HTML tags using tspan. Supported tags are: \code{b, strong, i, em, u, br, span}. Styling inside \code{span} can use \code{color, fontSize, fontWeight, fontStyle}. \code{x} and \code{y} attributes are automatically determined based on box size, unless specified. \code{padding_trbl} was also added to add padding - this must be a list of exactly 4 integers - in the order of top, right, bottom, and left padding. This padding just pushes the text in that direction.

- \strong{lineStyle} Styles the line that connects the annotation box to the arrow using \href{https://www.w3schools.com/graphics/svg_stroking.asp}{SVG stroke attributes}

- \strong{arrowStyle}: Styles the arrow. size was added that automatically adjusts the vertices of the triangle.
}
\note{
HTML tags may not apply in RStudio viewer, open in browser.
}
\examples{
# May not work render HTML correctly in RStudio viewer
# Open in browser
mtcars |>
  e_charts(mpg) |>
  e_scatter(wt) |>
  e_annotations(
    annotations = list(
      list(
        id = 0,
        x = 15,
        y = 3,
        text = 'An annotation<br>with <i>style</i>',
        offsetX = 0,
        offsetY = -50,
        textStyle = list(
          "font-size" = 14,
          "font-weight" = 'bold',
          color = "#394",
          padding_trbl = list(0, 0, 5, 0)
        ),
        rectStyle = list(
          `stroke-dasharray` = c(35, 10),
          `stroke-width` = 2,
              # Shadow can be added!
               shadow = list(
                 dx= 0,
                 dy= 2,
                 blur= 4,
                 color= '#000',
                 opacity= 0.3
               ),
          shape = list(width = 105, height = 50, r = 0)
        ),
        lineStyle = list(`stroke-width` = 2),
        arrowStyle = list(size = 8)
      ),
      # No styles, will just show text
      list(
        id = 0,
        x = 25,
        y = 1,
        text = 'No styles',
        lineStyle = "none",
        rectStyle = "none",
        arrowStyle = "none"
      ),
      # Default style
      list(
        id = 2,
        x = 25,
        y = 4.5,
        text = "Default style",
        offsetX = 0,
        offsetY = -40
      ),
      # left-aligned annotation
      list(
        id = 2,
        x = 0,
        y = 0.5,
        text = "I'm left<br>aligned!",
        offsetX = 60,
        offsetY = -40,
        textStyle = list(
          "text-anchor" = "start",
          padding_trbl = list(0, 0, 6, 10)
        )
      )
    ))
}
\seealso{
- \href{https://www.w3schools.com/graphics/svg_text.asp}{Additional arguments for textStyle}

- \href{https://www.w3schools.com/graphics/svg_stroking.asp}{Additional arguments for rectStyle}

- \href{https://www.w3schools.com/graphics/svg_stroking.asp}{Additional
arguments for lineStyle}

- \href{https://www.w3schools.com/graphics/svg_fill.asp}{Additional
arguments for arrowStyle}

- \href{https://developer.mozilla.org/en-US/docs/Web/SVG/Reference/Attribute}{Even more arguments for SVG attributes}
}
