% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiSampler.R
\name{multiSampler}
\alias{multiSampler}
\title{Multi-Sample VCG Generator and Overlap Visualization}
\usage{
multiSampler(formula, data, n, c_w = NULL, Nsamples = 20, plot = TRUE)
}
\arguments{
\item{formula}{A formula specifying the treated and covariates, e.g., `treated ~ cov1 + cov2`. The treated variable must be binary (0=pool, 1=treated)}

\item{data}{A data frame containing the variables specified in the formula.}

\item{n}{Integer. Number of observations to sample from the pool. Or a vector of n for each stratum.}

\item{c_w}{Optional: Vector of positive weights for covariates, reflecting the relative importance of the covariates for the balancing.}

\item{Nsamples}{Number of VCGs to generate (default is 20).}

\item{plot}{Logical; if `TRUE`, returns a ggplot2 plot showing the overlap of VCGs (default is `TRUE`).}
}
\value{
If `plot = TRUE`, returns a list with:
\describe{
  \item{data}{The original data frame with additional VCG columns (`VCG_1`, ..., `VCG_Nsamples`).}
  \item{p}{A `ggplot2` object showing the number of times each observation was selected across VCG samples.}
}
If `plot = FALSE`, returns the modified data frame only.
}
\description{
Repeatedly samples VCGs (via `VCG_sampler` with `random=TRUE`) from the pool,
optionally plots the overlap of VCGs.
}
\details{
The function repeatedly calls `VCG_sampler` with `random` set to TRUE
to generate multiple VCGs. It calculates the frequency of selection for each observation
and computes the average percentage of overlapping observations.
This function should only be used if you really need multiple VCGs, e.g. for PoC studies.
It is not intended for selecting one VCG from them afterwards!
In this case, the VCG_sampler function should be used directly and only one VCG should be generated.
}
\examples{

  dat <- data.frame(
  treat = rep(0:1, c(50, 30)),
  cov_1 = c(rnorm(50, 5, 2),   rnorm(30, 5, 1)),
  cov_2 = c(rnorm(50, 11, 2),  rnorm(30, 10, 1))
  )

  result <- multiSampler(treat ~ cov_1 + cov_2, data = dat, n = 10, Nsamples = 10)

}
