% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_data.R
\name{combine_data}
\alias{combine_data}
\title{Combine data from pool and treated groups}
\usage{
combine_data(POOL_data, TG_data, indicator_name = "treated")
}
\arguments{
\item{POOL_data}{Data frame with POOL data, where you want to sample from.}

\item{TG_data}{Data frame with TG (treated groups) data, all treated groups together!}

\item{indicator_name}{Name of the variable that is created for further use in the package, Default: 'treated'}
}
\value{
Data frame with all covariates that were present in both files and with new indicator factor POOL vs TG
}
\description{
If your data is stored in separate files, you can use this function to merge them.
}
\examples{

pool_data <- data.frame(
  cov1   = rnorm(100, 11, 2),
  cov2   = rnorm(100, 11, 2),
  cov3   = rnorm(100, 11, 2),
  sex    = rbinom(100, 1, 0.5))

tg_data <- data.frame(
  cov2   = rnorm(20, 12, 1),
  cov3   = rnorm(20, 12, 1),
  cov4   = rnorm(20, 12, 1),
  sex    = rbinom(20, 1, 0.5))

 dx <- combine_data(pool_data, tg_data)
 str(dx)

}
