% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scriptBifac.R
\name{scriptBifac}
\alias{scriptBifac}
\title{A Function That Writes, Saves, and Exports Syntax for
Fitting Bifactor Dyadic Models}
\usage{
scriptBifac(
  dvn,
  scaleset = "FF",
  lvname = "X",
  constr_dy_meas = c("loadings", "intercepts", "residuals"),
  constr_dy_struct = c("variances", "means"),
  writeTo = NULL,
  fileName = NULL
)
}
\arguments{
\item{dvn}{Input dvn list from \code{scrapeVarCross()}}

\item{scaleset}{Input character to specify how to set the scale of the latent variable. Default is
\code{"FF"} (fixed-factor; see Details for rationale), but user can specify \code{"MV"} (Marker Variable)}

\item{lvname}{Input character to (arbitrarily) name the latent variable in \code{lavaan} syntax}

\item{constr_dy_meas}{Input character vector detailing which measurement model parameters to constrain across dyad members.}

\item{constr_dy_struct}{Input character vector detailing which structural model parameters to constrain across dyad members.
Default is \code{c("variances", "means")}(in combination with defaults for \code{constr_dy_meas}, an indistinguishable correlated dyadic factors model),
but user can specify any combination of \code{"variances"} and \code{"means"}, or \code{"none"}.}

\item{writeTo}{A character string specifying a directory path to where a \code{.txt} file of the resulting \code{lavaan} script should be written.
If set to \verb{“.”}, the \code{.txt} file will be written to the current working directory.
The default is \code{NULL}, and examples use a temporary directory created by \code{tempdir()}.}

\item{fileName}{A character string specifying a desired base name for the \code{.txt} output file.
The default is \code{NULL}. The specified name will be automatically appended with the \code{.txt} file extension.
If a file with the same name already exists in the user's chosen directory, it will be overwritten.}
}
\value{
Character object of \code{lavaan} script that can be passed immediately to
\code{lavaan} functions.
}
\description{
This function takes the outputted object from \code{scrapeVarCross()}
and automatically writes, returns, and exports (\code{.txt}) \code{lavaan} syntax
for specifying dyadic configural, loading, intercept, and residual invariant
bifactor models.
}
\details{
\itemize{
\item By default, many \verb{dySEM::} functions (including \code{scriptBifac()}) default to
a fixed-factor method of scale-setting, whereby the latent variance of
a given factor is constrained to 1 for both partners in the configurally invariant
model, and then one of these variances is freely estimated in subsequent
models of the invariance testing sequence.
We have selected this default for two reasons:
(1) the selection of a marker-variable is usually arbitrary,
yet can have a large influence on the estimation and testing of of structural parameters
(see https://stats.stackexchange.com/questions/402133/in-cfa-does-it-matter-which-factor-loading-is-set-to-1/402732#402732);
and (2) the selection of a non-invariant marker-variable
can have disastrous down-stream consequences for the identification of
non-invariant measurement parameters, following a the rejection of an omnibus
invariance constraint set (see Lee, Preacher, & Little, 2011).
}
}
\examples{
dvn <- scrapeVarCross(
  dat = commitmentQ,
  x_order = "spi",
  x_stem = "sat.g",
  x_delim1 = ".",
  x_delim2 = "_",
  distinguish_1 = "1",
  distinguish_2 = "2"
)

sat.indist.script <- scriptBifac(
  dvn,
  scaleset = "FF",
  lvname = "Sat"
)

sat.lvars.script <- scriptBifac(
  dvn,
  scaleset = "FF",
  lvname = "Sat",
  constr_dy_meas = "loadings",
  constr_dy_struct = "variances"
)

sat.resids.script <- scriptBifac(
  dvn,
  scaleset = "FF",
  lvname = "Sat",
  constr_dy_meas = c("loadings", "intercepts", "residuals"),
  constr_dy_struct = "none",
  writeTo = tempdir(),
  fileName = "dBiFac_residual"
)

sat.ints.script <- scriptBifac(
  dvn,
  scaleset = "FF",
  lvname = "Sat",
  constr_dy_meas = c("loadings", "intercepts"),
  constr_dy_struct = "none",
  writeTo = tempdir(),
  fileName = "dBiFac_intercept"
)

sat.loads.script <- scriptBifac(
  dvn,
  scaleset = "FF",
  lvname = "Sat",
  constr_dy_meas = c("loadings"),
  constr_dy_struct = "none",
  writeTo = tempdir(),
  fileName = "dBiFac_loading"
)

sat.config.script <- scriptBifac(
  dvn,
  scaleset = "FF",
  lvname = "Sat",
  constr_dy_meas = "none",
  constr_dy_struct = "none",
  writeTo = tempdir(),
  fileName = "dBiFac_configural"
)

sat.source.script <- scriptBifac(
  dvn,
  scaleset = "FF",
  lvname = "Sat",
  constr_dy_meas = "loadings_source",
  constr_dy_struct = "none",
  writeTo = tempdir(),
  fileName = "dBiFac_source"
)
}
\seealso{
\code{\link{scrapeVarCross}} which this function relies on.

Other uni-construct script-writing functions: 
\code{\link{scriptCor}()},
\code{\link{scriptHier}()},
\code{\link{scriptUni}()}
}
\concept{uni-construct script-writing functions}
