% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputParamTab.R
\name{outputParamTab}
\alias{outputParamTab}
\title{A Function That Exports Tables based on dySEM models}
\usage{
outputParamTab(
  dvn,
  model = NULL,
  fit,
  tabletype = NULL,
  gtTab = FALSE,
  writeTo = NULL,
  fileName = NULL
)
}
\arguments{
\item{dvn}{Input dvn list from \code{scrapeVarCross()}}

\item{model}{A character input specifying type of model to output:
"cfa", "bidyc", "apim", "mim", "cfm", or "bidys".}

\item{fit}{input object from fitted \code{lavaan} model.}

\item{tabletype}{A character input of what type of table(s) is(are) desired.
Options are "measurement" (i.e., loadings, intercepts, etc.),
"structural" (i.e., latent slopes, such as actor/partner effects, k parameters),
"both" (i.e., both measurement and structural tables), or "correlation" (for a table of factor correlations).}

\item{gtTab}{A logical input indicating whether to generate the table(s) in \code{gt::gt()} table object format (\code{TRUE}).
By default (\code{FALSE}), the table(s) are generated in \code{tibble::tibble()} format.
Users can also apply the \code{writeTo} argument if they wish to export the \code{gt:gt()} table object(s).}

\item{writeTo}{A character string specifying a directory path to where the \code{gt::gt()} table object(s) should be saved.
If set to ".", the file(s) will be written to the current working directory.
The default is \code{NULL}, and examples use a temporary directory created by \code{tempdir()}.
\code{writeTo} is only relevant if \code{gtTab = TRUE}.}

\item{fileName}{A character string specifying a desired base name for the output \code{gt::gt()} file(s).
If a \code{fileName} is not provided (i.e., \code{fileName = NULL}), then defaults will be used
(e.g., "dySEM_table", "dySEM_table_measurement", or "dySEM_table_structural) based on the \code{tabletype} argument.
The resulting base name will automatically be appended with a \code{.rtf} file extension.
\code{fileName} is only relevant if \code{gtTab = TRUE} and \code{writeTo} is specified.}
}
\value{
A \code{tibble::tibble()} if \code{gtTab = FALSE} (default), or \code{gt::gt()} object if \code{gtTab = TRUE}, of specified model parameter estimates and corresponding statistical tests.
}
\description{
This function takes the model from fitted \code{dySEM} scripts and
creates tables of expected output and/or exports them as \code{.rtf}s.
}
\details{
\itemize{
\item If \code{gtTab = TRUE} and \code{writeTo} is specified, then output will simultaneously be saved as a \code{.rtf} file to the user's specified directory.
\item If output file(s) is(are) successfully saved, a confirmation message will be printed to the console.
\item If a file with the same name already exists in the user's chosen directory, it will be overwritten.
}
}
\examples{
dvnx <- scrapeVarCross(
  dat = commitmentQ, x_order = "spi", x_stem = "sat.g", x_delim1 = ".",
  x_delim2 = "_", distinguish_1 = "1", distinguish_2 = "2"
)

sat.config.script <- scriptCor(dvnx,
  lvname = "Sat", constr_dy_meas = "none",
  constr_dy_struct = "none"
)

sat.config.mod <- lavaan::cfa(sat.config.script,
  data = commitmentQ, std.lv = FALSE,
  auto.fix.first = FALSE, meanstructure = TRUE
)

outputParamTab(dvnx,
  model = "cfa", sat.config.mod, tabletype = "measurement",
  writeTo = tempdir(), fileName = "dCFA_configural"
)

dvnxy <- scrapeVarCross(
  dat = commitmentQ, x_order = "spi", x_stem = "sat.g", x_delim1 = ".",
  x_delim2 = "_", distinguish_1 = "1", distinguish_2 = "2",
  y_order = "spi", y_stem = "com", y_delim1 = ".", y_delim2 = "_"
)

apim.indist.script <- scriptAPIM(dvnxy, lvxname = "Sat", lvyname = "Com", est_k = TRUE)

apim.indist.mod <- lavaan::cfa(apim.indist.script,
  data = commitmentQ, std.lv = FALSE,
  auto.fix.first = FALSE, meanstructure = TRUE
)

outputParamTab(dvnxy,
  model = "cfa", sat.config.mod, tabletype = "measurement",
  writeTo = tempdir(), fileName = "APIM_indist"
)
}
