% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{log_filter}
\alias{log_filter}
\alias{log_filter.data.frame}
\alias{log_filter.list}
\title{Filter Data with Log}
\usage{
log_filter(data, condition, ...)

\method{log_filter}{data.frame}(data, condition, suffix = NULL, ...)

\method{log_filter}{list}(
  data,
  condition,
  table,
  by = c("USUBJID", "STUDYID"),
  suffix = NULL,
  verbose = FALSE,
  mode = ifelse(table == "adsl", "all", "unique"),
  ...
)
}
\arguments{
\item{data}{(\code{data.frame}) input data to subset, or named (\code{list} of \code{data.frame}).}

\item{condition}{(\code{call}) of subset condition. Must evaluate as logical.}

\item{...}{further arguments to be passed to or from other methods.}

\item{suffix}{(\code{string}) optional argument describing the filter.}

\item{table}{(\code{string}) table name.}

\item{by}{(\code{character}) variable names shared by \code{table} and other datasets for filtering when \code{mode == "all"}.}

\item{verbose}{(\code{flag}) whether to print a report about the filtering.}

\item{mode}{(\code{string}) one of \code{all} or \code{unique} whether the other tables should be filtered based on the rows
retained in \code{table}.
Default value is \code{"all"} is \code{table == "adsl"} and \code{"unique"} otherwise.}
}
\value{
a \code{data.frame} or \code{list} of \code{data.frame} filtered for the provided conditions.
}
\description{
Filter Data with Log
}
\details{
\code{log_filter} will filter the \code{data.frame} /named list of \code{data.frame} according to the \code{condition}.
All the variables in \code{condition} must exist in the data (as variables) or in the parent
frame(e.g., in global environment).
For a named list of \code{data.frame}, set \verb{mode = "all"`` to filter other tables by keys retained in table (using by), or }mode = "unique"` to leave other tables unchanged.
}
\examples{
data <- iris
attr(data$Sepal.Length, "label") <- "cm"
log_filter(data, Sepal.Length >= 7)

log_filter(list(iris = iris), Sepal.Length >= 7, "iris", character(0))
}
