% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete_calculus.R
\name{discrete_deriv}
\alias{discrete_deriv}
\title{Discrete differentiation}
\usage{
discrete_deriv(f, k, xd, x)
}
\arguments{
\item{f}{Function, or vector of function evaluations at \code{c(xd, x)}, the
design points \code{xd} adjoined with the query point(s) \code{x}.}

\item{k}{Order for the discrete derivative calculation. Must be >= 0.}

\item{xd}{Design points. Must be sorted in increasing order, and have length
at least \code{k+1}.}

\item{x}{Query point(s).}
}
\value{
Discrete derivative of \code{f} of order \code{k}, with respect to design
points \code{xd}, evaluated at the query point(s) \code{x}.
}
\description{
Computes the discrete derivative of a function (or vector of function
evaluations) of a given order, with respect to given design points, and
evaluated at a given query point.
}
\details{
The discrete derivative operator of order \eqn{k}, with respect
design points \eqn{x_1 < \ldots < x_n}, is denoted \eqn{\Delta^k_n}. Acting
on a function \eqn{f}, and evaluated at a query point \eqn{x}, it yields:
\deqn{
  (\Delta^k_n f) (x) =
  \begin{cases}
  k! \cdot f[x_{i-k+1},\ldots,x_i,x] & \text{if $x \in (x_i,x_{i+1}]$, $i
  \geq k$} \\
  i! \cdot f[x_1,\ldots,x_i,x] & \text{if $x \in (x_i,x_{i+1}]$, $i < k$} \\
  f(x) & \text{if $x \leq x_1$},
  \end{cases}
  }
where we take \eqn{x_{n+1} = \infty} for convenience. In other words, for
"most" points \eqn{x > x_k}, we define \eqn{(\Delta^k_n f)(x)} in terms of
a (scaled) divided difference of \eqn{f} of order \eqn{k}, where the
centers are the \eqn{k} points immediately to the left of \eqn{x}, and
\eqn{x} itself. Meanwhile, for "boundary" points \eqn{x \leq x_k}, we
define \eqn{(\Delta^k_n f)(x)} to be a (scaled) divided difference of
\eqn{f} of the highest possible order, where the centers are the points to
the left of \eqn{x}, and \eqn{x} itself. For more discussion, including
alternative representations for the discrete differentiation, see Section
3.1 of Tibshirani (2020).

\strong{Note:} for calculating discrete derivatives at the design points
themselves, which could be achieved by taking \code{x = xd} in the current
function, one should instead use \code{\link[=b_mat_mult]{b_mat_mult()}} or \code{\link[=d_mat_mult]{d_mat_mult()}}, as these
will be more efficient (both will be linear-time, but the latter functions
will be faster).
}
\examples{
xd = 1:10 / 10
discrete_deriv(function(x) x^2, 1, xd, xd)
}
\references{
Tibshirani (2020), "Divided differences, falling factorials, and
discrete splines: Another look at trend filtering and related problems",
Section 3.1.
}
\seealso{
\code{\link[=b_mat_mult]{b_mat_mult()}}, \code{\link[=d_mat_mult]{d_mat_mult()}} for multiplication by the extended
and non-extended discrete derivative matrices, giving discrete derivatives
at design points.
}
