% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.summary.R
\name{ds.summary}
\alias{ds.summary}
\title{Generates the summary of a server-side object}
\usage{
ds.summary(x = NULL, datasources = NULL)
}
\arguments{
\item{x}{a character string specifying the name of a numeric or factor variable.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} objects obtained after login. 
If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
\code{ds.summary} returns to the client-side the class and 
size of the server-side object. 
Also other information is returned depending on the class of the object.
For example, potentially disclosive information
such as the minimum and maximum values of numeric vectors are not returned. 
The summary is given for each study separately.
}
\description{
Generates the summary of a server-side object.
}
\details{
This function provides some insight about an object. Unlike the similar native R 
\code{summary} function
only a limited class of objects can be used as input to reduce the risk of disclosure.
For example, the minimum and the maximum values of a numeric vector
 are not given to the client because they are potentially disclosive. 
 
server functions called: \code{isValidDS}, \code{dimDS} and \code{colnamesDS}
}
\examples{
\dontrun{

  ## Version 6, for version 5 see the Wiki 
  
  # Connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
  logindata <- builder$build()

  # Log onto the remote Opal training servers
  connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D") 
  
  #Calculate the summary of a numeric variable
  
  ds.summary(x = "D$LAB_TSC",
             datasources = connections)
 
  #Calculate the summary of a factor variable

  ds.summary(x = "D$PM_BMI_CATEGORICAL",
             datasources = connections)
                                
  # Clear the Datashield R sessions and logout  
  datashield.logout(connections) 

}

}
\author{
DataSHIELD Development Team
}
