% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.rep.R
\name{ds.rep}
\alias{ds.rep}
\title{Creates a repetitive sequence in the server-side}
\usage{
ds.rep(
  x1 = NULL,
  times = NA,
  length.out = NA,
  each = 1,
  source.x1 = "clientside",
  source.times = NULL,
  source.length.out = NULL,
  source.each = NULL,
  x1.includes.characters = FALSE,
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{x1}{an scalar number, vector or list.}

\item{times}{an integer from clientside or a serverside integer
or vector.}

\item{length.out}{a clientside integer or a serverside integer
or vector.}

\item{each}{a clientside or serverside integer.}

\item{source.x1}{the source \code{x1} argument. It can be "clientside" or "c" 
and serverside or "s".}

\item{source.times}{see \code{source.x1}}

\item{source.length.out}{see \code{source.x1}}

\item{source.each}{see \code{source.x1}}

\item{x1.includes.characters}{Boolean parameter which specifies if 
the \code{x1} is a character.}

\item{newobj}{a character string that provides the name for the output object
that is stored on the data servers. Default \code{seq.vect}.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} objects obtained after login. 
If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
\code{ds.rep} returns in the server-side a vector with the specified repetitive sequence.  
Also, two validity messages are returned to the client-side
 the name of \code{newobj} that has been created 
in each data source and if it is in a valid form.
}
\description{
Creates a repetitive sequence by repeating
the specified scalar number, vector or list in each data source.
}
\details{
All arguments that can denote in a clientside  or
a serverside (i.e. \code{x1}, \code{times}, \code{length.out}
or \code{each}). 

Server function called: \code{repDS}.
}
\examples{
\dontrun{

  ## Version 6, for version 5 see the Wiki
  # Connecting to the Opal servers

    require('DSI')
    require('DSOpal')
    require('dsBaseClient')

    builder <- DSI::newDSLoginBuilder()
    builder$append(server = "study1", 
                   url = "http://192.168.56.100:8080/", 
                   user = "administrator", password = "datashield_test&", 
                   table = "CNSIM.CNSIM1", driver = "OpalDriver")
    builder$append(server = "study2", 
                   url = "http://192.168.56.100:8080/", 
                   user = "administrator", password = "datashield_test&", 
                   table = "CNSIM.CNSIM2", driver = "OpalDriver")
    builder$append(server = "study3",
                   url = "http://192.168.56.100:8080/", 
                   user = "administrator", password = "datashield_test&", 
                   table = "CNSIM.CNSIM3", driver = "OpalDriver")
    logindata <- builder$build()

  # Log onto the remote Opal training servers
    connections <- DSI::datashield.login(logins = logindata, 
                                         assign = TRUE, 
                                         symbol = "D") 

  # Creating a repetitive sequence  
              
     ds.rep(x1 = 4,
            times = 6,
            length.out = NA,
            each = 1,
            source.x1 = "clientside",
            source.times = "c",
            source.length.out = NULL,
            source.each = "c",
            x1.includes.characters = FALSE,
            newobj = "rep.seq",
            datasources = connections)
       
     ds.rep(x1 = "lung",
            times = 6,
            length.out = 7,
            each = 1,
            source.x1 = "clientside",
            source.times = "c",
            source.length.out = "c",
            source.each = "c",
            x1.includes.characters = TRUE,
            newobj = "rep.seq",
            datasources = connections)

  # Clear the Datashield R sessions and logout  
  datashield.logout(connections) 
} 

}
\author{
DataSHIELD Development Team
}
