% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{loglike_defm}
\alias{loglike_defm}
\title{Log-Likelihood of DEFM}
\usage{
loglike_defm(m, par, as_log = TRUE)
}
\arguments{
\item{m}{An object of class \link{DEFM}}

\item{par}{A vector of parameters of length \code{nterms_defm(m)}.}

\item{as_log}{Logical scalar. When \code{TRUE} (default) returns the log-likelihood,
otherwise it returns the likelihood.}
}
\value{
Numeric, the computed likelihood or log-likelihood of the model.
}
\description{
Log-Likelihood of DEFM
}
\examples{
# Loading Valtente's SNS data
data(valentesnsList)

mymodel <- new_defm(
  id    = valentesnsList$id,
  Y     = valentesnsList$Y,
  X     = valentesnsList$X,
  order = 1
)

# Adding the intercept terms and a motif from tobacco to mj
td_logit_intercept(mymodel)
td_formula(mymodel, "{y1, 0y2} > {y1, y2}")

# Computing the log-likelihood
loglike_defm(mymodel, par = c(-1, -1, -1, 2), as_log = TRUE)
}
