% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_robust.R
\name{interval_robust}
\alias{interval_robust}
\alias{int_trimmed_mean}
\alias{int_winsorized_mean}
\alias{int_trimmed_var}
\alias{int_winsorized_var}
\title{Robust Statistics for Interval Data}
\usage{
int_trimmed_mean(x, var_name, trim = 0.1, method = "CM", ...)

int_winsorized_mean(x, var_name, trim = 0.1, method = "CM", ...)

int_trimmed_var(x, var_name, trim = 0.1, method = "CM", ...)

int_winsorized_var(x, var_name, trim = 0.1, method = "CM", ...)
}
\arguments{
\item{x}{interval-valued data with symbolic_tbl class.}

\item{var_name}{the variable name or the column location (multiple variables are allowed).}

\item{trim}{the fraction (0 to 0.5) of observations to be trimmed from each end.}

\item{method}{methods to calculate statistics: CM (default), VM, QM, SE, FV, EJD, GQ, SPT.}

\item{...}{additional parameters}
}
\value{
A numeric matrix
}
\description{
Functions to compute robust statistics for interval-valued data.
}
\details{
These functions provide robust alternatives to standard statistics:
\itemize{
  \item \code{int_trimmed_mean}: Mean after trimming extreme values
  \item \code{int_winsorized_mean}: Mean after winsorizing extreme values
  \item \code{int_trimmed_var}: Variance after trimming extreme values
  \item \code{int_winsorized_var}: Variance after winsorizing extreme values
}

Trimming vs Winsorizing:
\itemize{
  \item Trimming: Remove extreme values
  \item Winsorizing: Replace extreme values with less extreme values
}
}
\examples{
data(mushroom.int)

# Trimmed mean (10\% from each end)
int_trimmed_mean(mushroom.int, var_name = "Pileus.Cap.Width", trim = 0.1)

# Winsorized mean
int_winsorized_mean(mushroom.int, var_name = 2:3, trim = 0.05, method = "CM")

# Trimmed variance
int_trimmed_var(mushroom.int, var_name = c("Stipe.Length"), trim = 0.1)
}
\seealso{
int_mean int_var int_trimmed_mean
}
\author{
Han-Ming Wu
}
