% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_dendrogram.R
\name{plot_dendrogram}
\alias{plot_dendrogram}
\title{Plot dendrogram}
\usage{
plot_dendrogram(hc, labels = TRUE, label_size = 3, title = NULL)
}
\arguments{
\item{hc}{an object of class \code{hclust} or \code{dendrogram}}

\item{labels}{logical; whether to draw leaf labels}

\item{label_size}{label text size}

\item{title}{optional plot title}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Dendrogram plot for an hclust or dendrogram object using ggplot2.
}
\details{
Converts a dendrogram into line segments and renders it with ggplot2.
}
\examples{
data(iris)
hc <- hclust(dist(scale(iris[,1:4])), method = "ward.D2")
grf <- plot_dendrogram(hc)
plot(grf)
}
