% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_cspade.R
\name{pat_cspade}
\alias{pat_cspade}
\title{cSPADE sequences}
\usage{
pat_cspade(parameter = list(support = 0.4), control = list(verbose = TRUE))
}
\arguments{
\item{parameter}{list of parameters passed to \code{arulesSequences::cspade}}

\item{control}{list of control parameters}
}
\value{
returns a \code{pat_cspade} object
}
\description{
Sequential pattern mining using \code{arulesSequences::cspade}.
}
\examples{
x <- arulesSequences::read_baskets(
 con = system.file("misc", "zaki.txt", package = "arulesSequences"),
 info = c("sequenceID", "eventID", "SIZE")
)
pm <- pat_cspade(parameter = list(support = 0.4))
pm <- fit(pm, x)
seqs <- discover(pm)
as(seqs, "data.frame")
}
