% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_base_ed.R
\name{autoenc_base_ed}
\alias{autoenc_base_ed}
\title{Autoencoder base (encoder + decoder)}
\usage{
autoenc_base_ed(input_size, encoding_size)
}
\arguments{
\item{input_size}{dimensionality of the input vector}

\item{encoding_size}{dimensionality of the latent (encoded) vector}
}
\value{
returns an \code{autoenc_base_ed} object
}
\description{
Base class for autoencoders that both encode and decode. Intended to be subclassed
by concrete implementations that learn to compress and reconstruct inputs.
}
\details{
This base does not train or transform by itself (identity). Implementations should
override \code{fit()} to learn parameters and \code{transform()} to perform encode+decode.
}
\examples{
# See an end‑to‑end example at:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/autoencoder/autoenc_base_ed.md

}
\references{
Hinton, G. E., & Salakhutdinov, R. R. (2006). Reducing the Dimensionality of Data with Neural Networks. Science.
}
