% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design-class.R
\docType{class}
\name{TDDesign-class}
\alias{TDDesign-class}
\alias{.TDDesign}
\alias{TDDesign}
\alias{.DefaultTDDesign}
\title{\code{TDDesign}}
\usage{
TDDesign(
  model,
  stopping,
  increments,
  pl_cohort_size = CohortSizeConst(0L),
  ...
)

.DefaultTDDesign()
}
\arguments{
\item{model}{(\code{ModelTox})\cr see slot definition.}

\item{stopping}{(\code{Stopping})\cr see slot definition.}

\item{increments}{(\code{Increments})\cr see slot definition.}

\item{pl_cohort_size}{(\code{CohortSize})\cr see slot definition.}

\item{...}{
  Arguments passed on to \code{\link[=RuleDesign]{RuleDesign}}
  \describe{
    \item{\code{nextBest}}{(\code{NextBest})\cr see slot definition.}
    \item{\code{cohort_size}}{(\code{CohortSize})\cr see slot definition.}
    \item{\code{data}}{(\code{Data})\cr see slot definition.}
    \item{\code{startingDose}}{(\code{number})\cr see slot definition.}
  }}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{TDDesign}} is the class of design based only on DLT responses using
\code{\link{ModelTox}} class model (i.e. \code{\link{LogisticIndepBeta}}) without MCMC samples.
}
\section{Slots}{

\describe{
\item{\code{model}}{(\code{ModelTox})\cr the pseudo DLT model to be used.}

\item{\code{stopping}}{(\code{Stopping})\cr stopping rule(s) for the trial.}

\item{\code{increments}}{(\code{Increments})\cr how to control increments between dose levels.}

\item{\code{pl_cohort_size}}{(\code{CohortSize})\cr rules for the cohort sizes for placebo,
if any planned (defaults to constant 0 placebo patients).}
}}

\note{
Typically, end users will not use the \code{.DefaultTDDesign()} function.
}
\examples{
empty_data <- Data(doseGrid = seq(25, 300, 25))

my_model <- LogisticIndepBeta(
  binDLE = c(1.05, 1.8),
  DLEweights = c(3, 3),
  DLEdose = c(25, 300),
  data = empty_data
)

# The escalation rule.
my_next_best <- NextBestTD(
  prob_target_drt = 0.35,
  prob_target_eot = 0.3
)

my_size <- CohortSizeConst(size = 3)

# The increments for the dose-escalation process:
#  the maximum increase of 200\% for doses up to the maximum dose in grid,
#  the maximum increase of 200\% for dose above the maximum dose in grid.
my_increments <- IncrementsRelative(
  intervals = range(empty_data@doseGrid),
  increments = c(2, 2)
)

# Stop when the maximum sample size of 36 patients is reached.
my_stopping <- StoppingMinPatients(nPatients = 36) | StoppingMissingDose()

# The design with all the above information and starting with a dose of 25.
# This design incorporates only DLT responses and no DLT samples are involved
# during the simulation.
design <- TDDesign(
  model = my_model,
  stopping = my_stopping,
  increments = my_increments,
  nextBest = my_next_best,
  cohort_size = my_size,
  data = empty_data,
  startingDose = 25
)
}
