% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{ProbitLogNormalRel-class}
\alias{ProbitLogNormalRel-class}
\alias{.ProbitLogNormalRel}
\alias{ProbitLogNormalRel}
\alias{.DefaultProbitLogNormalRel}
\title{\code{ProbitLogNormalRel}}
\usage{
ProbitLogNormalRel(mean, cov, ref_dose = 1)

.DefaultProbitLogNormalRel()
}
\arguments{
\item{mean}{(\code{numeric})\cr the prior mean vector.}

\item{cov}{(\code{matrix})\cr the prior covariance matrix. The precision matrix
\code{prec} is internally calculated as an inverse of \code{cov}.}

\item{ref_dose}{(\code{number})\cr the reference dose \eqn{x*} (strictly positive
number).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{ProbitLogNormalRel}} is the class for probit regression model with a bivariate
normal prior on the intercept and log slope.
}
\details{
The covariate is the dose \eqn{x} divided by a reference dose \eqn{x*},
i.e.:
\deqn{probit[p(x)] = alpha0 + alpha1 * x/x*,}
where \eqn{p(x)} is the probability of observing a DLT for a given dose \eqn{x}.
The prior \deqn{(alpha0, log(alpha1)) ~ Normal(mean, cov).}
}
\note{
This model is also used in the \code{\link{DualEndpoint}} classes, so this class
can be used to check the prior assumptions on the dose-toxicity model, even
when sampling from the prior distribution of the dual endpoint model is not
possible.

Typically, end users will not use the \code{.DefaultProbitLogNormalRel()} function.
}
\examples{
my_model <- ProbitLogNormalRel(
  mean = c(-0.85, 1),
  cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2)
)
}
\seealso{
\code{\link{ModelLogNormal}}, \code{\link{LogisticNormal}}, \code{\link{LogisticLogNormal}},
\code{\link{LogisticLogNormalSub}}, \code{\link{ProbitLogNormal}}.
}
