% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_tensor.R
\name{build_tensor}
\alias{build_tensor}
\title{Build Tensor}
\usage{
build_tensor(x = NULL, y = NULL, ...)
}
\arguments{
\item{x}{a matrix}

\item{y}{a matrix}

\item{...}{additional numeric matrices to build the tensor product}
}
\value{
a matrix

A matrix
}
\description{
Tensor products of Matrices.
}
\examples{

A <- matrix(1:4, nrow = 10, ncol = 20)
B <- matrix(1:6, nrow = 10, ncol = 6)

# Two ways of building the same tensor product
tensor1 <- build_tensor(A, B)
tensor2 <- do.call(build_tensor, list(A, B))
all.equal(tensor1, tensor2)

# a three matrix tensor product
tensor3 <- build_tensor(A, B, B)
str(tensor3)

}
\seealso{
\code{vignette("cnr", package = "cpr")} for details on tensor products.
}
