% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap_solve.R
\name{assignment}
\alias{assignment}
\title{Linear assignment solver}
\usage{
assignment(
  cost,
  maximize = FALSE,
  method = c("auto", "jv", "hungarian", "auction", "auction_gs", "auction_scaled", "sap",
    "ssp", "csflow", "hk01", "bruteforce", "ssap_bucket", "cycle_cancel", "gabow_tarjan",
    "lapmod", "csa", "ramshaw_tarjan", "push_relabel", "orlin", "network_simplex"),
  auction_eps = NULL,
  eps = NULL
)
}
\arguments{
\item{cost}{Numeric matrix; rows = tasks, columns = agents. \code{NA} or \code{Inf}
entries are treated as forbidden assignments.}

\item{maximize}{Logical; if \code{TRUE}, maximizes the total cost instead of minimizing.}

\item{method}{Character string indicating the algorithm to use. Options:

\strong{General-purpose solvers:}
\itemize{
\item \code{"auto"} — Automatic selection based on problem characteristics (default)
\item \code{"jv"} — 'Jonker-Volgenant', fast general-purpose O(n³)
\item \code{"hungarian"} — Classic 'Hungarian' algorithm O(n³)
}

\strong{Auction-based solvers:}
\itemize{
\item \code{"auction"} — 'Bertsekas' auction with adaptive epsilon
\item \code{"auction_gs"} — 'Gauss-Seidel' variant, good for spatial structure
\item \code{"auction_scaled"} — 'Epsilon-scaling', fastest for large dense problems
}

\strong{Specialized solvers:}
\itemize{
\item \code{"sap"} / \code{"ssp"} — Shortest augmenting path, handles sparsity well
\item \code{"lapmod"} — Sparse JV variant, faster when >50\\% entries are NA/Inf
\item \code{"hk01"} — 'Hopcroft-Karp' for binary (0/1) costs only
\item \code{"ssap_bucket"} — 'Dial' algorithm for integer costs
\item \code{"line_metric"} — O(n log n) for 1D assignment problems
\item \code{"bruteforce"} — Exact enumeration for tiny problems (n <= 8)
}

\strong{Advanced solvers:}
\itemize{
\item \code{"csa"} — 'Goldberg-Kennedy' cost-scaling, often fastest for medium-large
\item \code{"gabow_tarjan"} — 'Gabow-Tarjan' bit-scaling with complementary slackness O(n³ log C)
\item \code{"cycle_cancel"} — Cycle-canceling with 'Karp' algorithm
\item \code{"csflow"} — Cost-scaling network flow
\item \code{"network_simplex"} — 'Network simplex' with spanning tree representation
\item \code{"orlin"} — 'Orlin-Ahuja' scaling O(sqrt(n) * m * log(nC))
\item \code{"push_relabel"} — 'Push-relabel' max-flow based solver
\item \code{"ramshaw_tarjan"} — 'Ramshaw-Tarjan', optimized for rectangular matrices (n != m)
}}

\item{auction_eps}{Optional numeric epsilon for the 'Auction'/'Auction-GS' methods.
If \code{NULL}, an internal default (e.g., \code{1e-9}) is used.}

\item{eps}{Deprecated. Use \code{auction_eps}. If provided and \code{auction_eps} is \code{NULL},
its value is used for \code{auction_eps}.}
}
\value{
An object of class \code{lap_solve_result}, a list with elements:
\itemize{
\item \code{match} — integer vector of length \code{min(nrow(cost), ncol(cost))}
giving the assigned column for each row (0 if unassigned).
\item \code{total_cost} — numeric scalar, the objective value.
\item \code{status} — character scalar, e.g. \code{"optimal"}.
\item \code{method_used} — character scalar, the algorithm actually used.
}
}
\description{
Solve the linear assignment problem (minimum- or maximum-cost matching)
using several algorithms. Forbidden edges can be marked as \code{NA} or \code{Inf}.
}
\details{
\code{method = "auto"} selects an algorithm based on problem size/shape and data
characteristics:
\itemize{
\item Very small (n <= 8): \code{"bruteforce"} — exact enumeration
\item Binary/constant costs: \code{"hk01"} — specialized for 0/1 costs
\item Large sparse (n>100, >50\\% NA/Inf): \code{"lapmod"} — sparse JV variant
\item Sparse or very rectangular: \code{"sap"} — handles sparsity well
\item Small-medium (8 < n <= 50): \code{"hungarian"} — provides exact dual solutions
\item Medium (50 < n <= 75): \code{"jv"} — fast general-purpose solver
\item Large (n>75): \code{"auction_scaled"} — fastest for large dense problems
}
Benchmarks show 'Auction-scaled' and 'JV' are 100-1500x faster than 'Hungarian' at n=500.
}
\examples{
cost <- matrix(c(4,2,5, 3,3,6, 7,5,4), nrow = 3, byrow = TRUE)
res  <- assignment(cost)
res$match; res$total_cost

}
\seealso{
\itemize{
\item \code{\link[=lap_solve]{lap_solve()}} — Tidy interface returning tibbles
\item \code{\link[=lap_solve_kbest]{lap_solve_kbest()}} — Find k-best assignments ('Murty' algorithm)
\item \code{\link[=assignment_duals]{assignment_duals()}} — Extract dual variables for sensitivity analysis
\item \code{\link[=bottleneck_assignment]{bottleneck_assignment()}} — Minimize maximum edge cost (minimax)
\item \code{\link[=sinkhorn]{sinkhorn()}} — Entropy-regularized optimal transport
}
}
