% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corx.R
\name{corx}
\alias{corx}
\title{corx}
\usage{
corx(
  data,
  x = NULL,
  y = NULL,
  z = NULL,
  method = c("pearson", "spearman", "kendall"),
  stars = c(0.05, 0.01, 0.001),
  p_adjust = c("none", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr"),
  round = 2,
  remove_lead = TRUE,
  triangle = NULL,
  caption = NULL,
  note = NULL,
  describe = FALSE,
  grey_nonsig = TRUE,
  call_only = FALSE
)
}
\arguments{
\item{data}{data.frame or matrix}

\item{x}{a vector of rownames. Defaults to all}

\item{y}{a vector of colnames. If not supplied, y is set to x.}

\item{z}{a vector of variable names. Control variables to be used in partial correlations - defaults to NULL}

\item{method}{character. One of "pearson", "spearman", or "kendall"}

\item{stars}{a numeric vector. This argument defines cut-offs for p-value stars.}

\item{p_adjust}{character. What adjustment for multiple tests should be used? One of "none" (default), "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", or "fdr"}

\item{round}{numeric. How many digits should correlation coefficients be rounded to in printing?}

\item{remove_lead}{logical. if TRUE (the default), leading zeros are removed in summaries}

\item{triangle}{character. one of "lower", "upper" or NULL (the default)}

\item{caption}{character. table caption. Passed to plots}

\item{note}{character. Text for a table note}

\item{describe}{list of named functions. If functions are supplied to describe, new columns will be bound to the 'APA matrix' for each function in the list. Describe also accepts a variety of shortcuts. If describe is set to TRUE, mean and standard deviation are returned for all row variables. Describe can accept a character vector to call the following descriptive functions: c('mean','sd','var','median','iqr','skewness','kurtosis'). These shortcuts are powered by 'tidyselect'. Skewness and kurtosis are calculated using the 'moments' package. All functions retrieved with shortcuts remove missing values.}

\item{grey_nonsig}{logical. Should non-significant values be grey in output? This argument does nothing if describe is not set to FALSE}

\item{call_only}{logical. For debugging, if TRUE only the call is returned}
}
\value{
A list of class 'corx' which includes:
 * "call" The call which if evaluated reproduces the object
 * "apa" An 'APA' formatted correlation matrix with significance stars
 * "r" Raw correlation coefficients
 * "p" p-values
 * "n" Pairwise observations
 * "caption" Object caption
 * "note" Object note
}
\description{
Calculates correlations matrices. Relevant values are stored in a list with methods for easy retrieval and formatting in publication ready tables.
}
\details{
Constructs correlation matrices using 'stats::cor.test' unless z is specified. When z is specified ppcor::ppcor.test is used instead. Character and factor variables are not accepted. To prevent errors, users must first convert all variables to numeric.

## Partial correlations:

Supplying the argument z will call ppcor::pcor.test the correlation pair are supplied to arguments x and y. The vector of z given to corx is passed to argument z in pcor.test.

##  Missing data:

Observations containing missing data required to complete a correlation or partial correlation are automatically removed.

## P-adjust:

P-values attained can be adjusted for multiple comparisons by using the 'p_adjust' argument. This calls the function stats::p.adjust. When a matrix is symmetrical, p-values are only adjusted for unique comparisons. When a correlation matrix is not symmetrical, all comparisons are assumed to be unique.
}
\examples{
cor_mat <- corx(mtcars, x = c(mpg,cyl,disp), y = c(wt,drat,disp,qsec),
           z = wt, round = 2, stars = c(0.05),
           caption = "Controlling for weight" ,
           describe = list("mean" = function(x) mean(x,na.rm=TRUE)))
cor_mat
coef(cor_mat)
cor_mat$p
plot(cor_mat)
cor_2 <- corx(iris[,-5], describe = c(median, IQR = iqr, kurt = kurtosis),
         note = "Using shortcuts to select describe functions", triangle = "lower")
cor_2
}
