% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertId2.R
\name{todisp2}
\alias{todisp2}
\title{Convenience Function to Convert Ensembl Gene IDs to Gene Symbols}
\usage{
todisp2(ensg, lab = NULL, biomart = TRUE, verbose = FALSE)
}
\arguments{
\item{ensg}{(\code{character}). Vector of Ensemble Gene IDs. Other ID types are not yet supported.}

\item{lab}{(\code{data.frame}). A data frame with Ensembl Gene IDs as row names and Gene Symbols in the only column.}

\item{biomart}{(\code{logical}). Should Biomart be used? Defaults to \code{TRUE}.}

\item{verbose}{(\code{logical}). Should verbose output be written to the console? Defaults to \code{FALSE}.}
}
\value{
A character vector of Gene Symbols.
}
\description{
\command{todisp2()} uses Biomart by employing \command{get.bm()} to retrieve Gene Symbols for a set of Ensembl
    Gene IDs. It is mainly meant as a fast way to convert IDs in standard gene expression analysis output to Symbols,
    e.g., for visualisation, which is why the input ID type is hard coded to ENSG IDs. If Biomart is not available
    the function can fall back to use \command{convertId2()} or a user-provided data frame with corresponding ENSG IDs and
    Symbols.
}
\examples{
\dontrun{
val <- c("ENSG00000111199", "ENSG00000134121", "ENSG00000176102", "ENSG00000171611")
sym <- todisp2(val)
sym
}
}
\seealso{
\command{\link[convertid]{get.bm}}
}
\keyword{utilities}
