% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cacf.R
\name{cacf}
\alias{cacf}
\alias{cpacf}
\alias{print.cacf}
\alias{plot.cacf}
\title{Complex Correlation Function Estimation}
\usage{
cacf(x, lag.max = NULL, method = c("direct", "conjugate", "pearson",
  "kendall", "spearman"), type = c("correlation", "covariance", "partial"),
  plot = TRUE, ...)

cpacf(x, lag.max = NULL, method = c("direct", "conjugate", "pearson",
  "kendall", "spearman"), plot = TRUE, ...)

\method{print}{cacf}(x, ...)

\method{plot}{cacf}(x, which = c(1, 2), ask = length(which) > 1,
  level = 0.95, ...)
}
\arguments{
\item{x}{vector of complex variables.}

\item{lag.max}{maximum number of lags. See \link[stats]{acf} for more details.}

\item{method}{method to use in the calculation of the measure. \code{"conjugate"} means that it is based
on the multiplication by conjugate number. \code{"direct"} means the calculation
without the conjugate (i.e. "pseudo" moment). \code{method}
can also be "pearson", "kendall", or "spearman", defining what correlation coefficient
to use after the MDS transformation of complex variables \code{x} and \code{y}.}

\item{type}{character string giving the type of cACF to be computed. Allowed values
are "correlation" (the default) and "covariance". Will be partially matched.}

\item{plot}{logical. If \code{TRUE} (the default) the cACF is plotted on complex plane
and as two linear graphs for real and imaginary parts.}

\item{...}{Parameter for the plot() function.}

\item{which}{Determines, which of the plots to produce. 1 is the plot of real
and imaginary parts. 2 is the plot of absolute value and the argument.}

\item{ask}{Determines, whether to ask before producing a new plot or not.}

\item{level}{Confidence level for the non-rejection region of the correlation
coefficient.}
}
\value{
An object of class "cacf", which is a list with the following elements:
\itemize{
\item \code{lag} A three dimensional array containing the lags at which the cACF is estimated.
\item \code{acf} An array with the same dimensions as lag containing the estimated cACF.
\item \code{method} The method used in calculation (same as the method argument).
\item \code{type} The type of correlation (same as the type argument).
\item \code{n.used} The number of observations in the time series.
\item \code{series} The name of the series x.
}
}
\description{
The functions compute (and by default plot) estimates of the Complex Autocovariance,
or Complex Autocorrelation, or Partial Complex Autocorrelation functions.
}
\details{
For \code{type="correlation"} and \code{"covariance"}, the estimates are based
on the sample pseudo covariance and use pseudo correlation \link[complex]{ccor} and complex
covariance \link[complex]{ccov} respectively. Note that the function does not calculate values for
lag 0. Also, the function will automatically remove NAs. Finally, function does not have
\code{demean} parameter (as, for example, is done in \link[stats]{acf}), because \code{ccov()}
and \code{ccor()} do that automatically.

\code{cpacf()} produces the partial complex ACF based on complex regression model of variable
on its lags.

The generic function plot has a method for objects of class "cacf".

The lag is returned and plotted in units of time, and not numbers of observations.

There is a print and plot methods for objects of class "cacf".
}
\examples{

# Generate random complex variables
x <- complex(real=rnorm(100,10,10), imaginary=rnorm(100,10,10))

# Calculate cACF
cacf(x)

}
\references{
\itemize{
\item Svetunkov, S. & Svetunkov I. (2022) Complex Autoregressions. In Press.
}
}
\seealso{
\link[stats]{acf}, \link[complex]{ccor}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{univar}
