% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkAssumptionsForAnova}
\alias{checkAssumptionsForAnova}
\title{Check the assumptions for an ANOVA with a variable number of factors: Normality and Homogeneity of variance assumption.}
\usage{
checkAssumptionsForAnova(data, y, factors)
}
\arguments{
\item{data}{the data frame}

\item{y}{The dependent variable for which assumptions should be checked}

\item{factors}{A character vector of factor names}
}
\value{
A message indicating whether to use parametric or non-parametric ANOVA
}
\description{
Check the assumptions for an ANOVA with a variable number of factors: Normality and Homogeneity of variance assumption.
}
\examples{
\donttest{
set.seed(123)

main_df <- data.frame(
  tlx_mental      = rnorm(40),
  Video           = factor(rep(c("A", "B"), each = 20)),
  DriverPosition  = factor(rep(c("Left", "Right"), times = 20))
)

checkAssumptionsForAnova(
  data    = main_df,
  y       = "tlx_mental",
  factors = c("Video", "DriverPosition")
)
}
}
