% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{reportART}
\alias{reportART}
\title{Generate the Latex-text based on the ARTool (see \url{https://github.com/mjskay/ARTool}). The ART result must be piped into an anova().
Only significant main and interaction effects are reported.
P-values are rounded for the third digit.
Attention: Effect sizes are not calculated!
Attention: the independent variables of the formula and the term specifying the participant must be factors (i.e., use as.factor()).}
\usage{
reportART(model, dv = "Testdependentvariable", write_to_clipboard = FALSE)
}
\arguments{
\item{model}{the model of the art}

\item{dv}{the name of the dependent variable that should be reported}

\item{write_to_clipboard}{whether to write to the clipboard}
}
\value{
A message describing the statistical results.
}
\description{
To easily copy and paste the results to your manuscript, the following commands must be defined in Latex:
\code{\\newcommand{\\F}[3]{$F({#1},{#2})={#3}$}}
\code{\\newcommand{\\p}{\\textit{p=}}}
\code{\\newcommand{\\pminor}{\\textit{p$<$}}}
}
\examples{
\donttest{
if (requireNamespace("ARTool", quietly = TRUE)) {
  set.seed(123)

  main_df <- data.frame(
    tlx_mental = stats::rnorm(80),
    Video      = factor(rep(c("A", "B"), each = 40)),
    gesture    = factor(rep(c("G1", "G2"), times = 40)),
    eHMI       = factor(rep(c("On", "Off"), times = 40)),
    UserID     = factor(rep(1:20, each = 4))
  )

  art_model <- ARTool::art(
    tlx_mental ~ Video * gesture * eHMI +
      Error(UserID / (gesture * eHMI)),
    data = main_df
  )

  model_anova <- stats::anova(art_model)
  reportART(model_anova, dv = "mental demand")
}
}
}
