% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{student_t}
\alias{student_t}
\title{Student-t Distribution for Prior Specification}
\usage{
student_t(df = 3, mu = 0, sigma = 1)
}
\arguments{
\item{df}{Degrees of freedom. Must be positive. Default: 3}

\item{mu}{Location parameter. Default: 0}

\item{sigma}{Scale parameter. Must be positive. Default: 1}
}
\value{
An object of class \code{"clm_dist"} representing a Student-t distribution.
}
\description{
Creates a Student-t distribution object for use with \code{\link[=prior]{prior()}}.
}
\examples{
# Create a Student-t prior with heavy tails
student_t(3, 0, 2.5)

# Use with prior()
prior(student_t(3, 0, 2.5), class = "b")
}
\seealso{
\code{\link[=prior]{prior()}}, \code{\link[=normal]{normal()}}, \code{\link[=gamma]{gamma()}}, \code{\link[=cauchy]{cauchy()}}
}
