% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge_by_substring}
\alias{merge_by_substring}
\title{Merge Data Frame by String Key Matching}
\usage{
merge_by_substring(data, key_df, search_col, key_col, value_cols)
}
\arguments{
\item{data}{The primary data frame to be enhanced with additional columns}

\item{key_df}{A data frame containing string keys and their corresponding values}

\item{search_col}{Column name in \code{data} to search for keys (default: "name")}

\item{key_col}{Column name in \code{key_df} containing keys to match (default: "key")}

\item{value_cols}{Column name(s) in \code{key_df} to add to \code{data} (default: "value")
Can be a single column name or a character vector of column names}
}
\value{
A data frame with all columns from \code{data} plus matched columns from \code{key_df}.
Unmatched rows will have NA values in the added columns.
}
\description{
This function merges two data frames based on string key matching.
It searches for keys from \code{key_df[[key_col]]} in \code{data[[search_col]]}
and adds corresponding columns from \code{key_df} to \code{data}.
}
\examples{
# Basic usage
main_data <- data.frame(
  name = c("AB", "B,C", "A..", "ACD"),
  value = c(1, 2, 3, 4),
  stringsAsFactors = FALSE
)
key_lookup <- data.frame(
  key = c("A", "B", "C", "ACD", "AB"),
  category = c("cat1", "cat2", "cat3", "cat4", "cat1"),
  code = c("001", "002", "003", "004", "001"),
  stringsAsFactors = FALSE
)
result <- merge_by_substring(main_data, key_lookup,
  search_col = "name",
  key_col = "key", value_cols = c("category", "code")
)
print(result)

}
