% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_variables.R
\name{compare_variables}
\alias{compare_variables}
\title{Compare Variables of Two Datasets}
\usage{
compare_variables(df1, df2)
}
\arguments{
\item{df1}{A data frame representing the first dataset.}

\item{df2}{A data frame representing the second dataset.}
}
\value{
A list containing variable comparison details and discrepancy count.
}
\description{
Compares the structural attributes of two datasets including column names,
data types, and variable ordering. Identifies common columns and reports columns
that exist in only one dataset.
}
\examples{
\donttest{
  df1 <- data.frame(id = 1:3, name = c("A", "B", "C"))
  df2 <- data.frame(id = 1:3, name = c("A", "B", "C"), score = c(90, 80, 70))
  compare_variables(df1, df2)
}
}
