% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_ci_common_risk.R
\name{ci_rel_risk_cmh_strata}
\alias{ci_rel_risk_cmh_strata}
\title{Mantel-Haenszel Stratified Relative Risk Confidence Interval}
\usage{
ci_rel_risk_cmh_strata(x, by, strata, conf.level = 0.95, data = NULL)
}
\arguments{
\item{x}{(\code{binary}/\code{numeric}/\code{logical})\cr
vector of a binary values, i.e. a logical vector, or numeric with values \code{c(0, 1)}}

\item{by}{(\code{string}) \cr A character or factor vector with exactly two unique levels
identifying the two groups to compare. Can also be a column name if a data
frame provided in the \code{data} argument.}

\item{strata}{(\code{numeric}) \cr A vector specifying the stratum for each observation. It needs
to be the length of x or a multiple of x if multiple levels of strata are
present. Can also be a column name (or vector of column names NOT quoted)
if a data frame provided in the \code{data} argument.}

\item{conf.level}{(\verb{scalar numeric}) \cr a scalar in (0,1) indicating the confidence level. Default is 0.95}

\item{data}{(\code{data.frame}) \cr Optional data frame containing the variables specified in \code{x} and \code{by}.}
}
\value{
An object containing the following components:

\item{estimate}{The Mantel-Haenszel estimated common risk difference}
\item{conf.low}{Lower bound of the confidence interval}
\item{conf.high}{Upper bound of the confidence interval}
\item{conf.level}{The confidence level used}
\item{variance}{Mantel-Haenszel variance estimate \eqn{Var(log(RR_MH))}}
\item{method}{Description of the method used ("Mantel-Haenszel Common Relative Risk Confidence Interval")}
}
\description{
Calculates the confidence interval for the Mantel-Haenszel estimate of the
common relative risk across multiple 2x2 tables (strata)
}
\details{
The Mantel-Haenszel relative risk difference is computed as:

\deqn{RR_{MH} = \frac{\sum_{k} s_{xk}~n_{yk}/N_k}{\sum_{k} s_{yk}~n_{xk}/N_k}}

The variance is:

\deqn{\hat{\sigma}^2 = \hat{Var}(log(RR_{MH})) =
\frac{\sum_{k}(n_{xk}~n_{yk}~(s_{xk}+s_{yk}) - s_{xk}~s_{yk}~N_k)/N_k^2}
{(\sum_{k}s_{xk}~n_{yk}/N_k)(\sum_{k}s_{yk}~n_{xk}/N_k)}}

The confidence interval is then \eqn{\left(RR_{MH}\times exp(-z_{1-\alpha/2} \sqrt{\hat{\sigma}^2},
RR_{MH}\times exp(z_{1-\alpha/2} \sqrt{\hat{\sigma}^2}\right)}.
}
\examples{
# Generate binary samples with strata
responses <- expand(c(9, 3, 7, 2), c(10, 10, 10, 10))
arm <- rep(c("treat", "control"), 20)
strata <- rep(c("stratum1", "stratum2"), times = c(20, 20))

# Calculate common risk difference
ci_rel_risk_cmh_strata(x = responses, by = arm, strata = strata)
}
\references{
Agresti, A. (2013). Categorical Data Analysis. 3rd Edition. John Wiley & Sons, Hoboken, NJ
}
