% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_ci_diff.R
\name{ci_prop_diff_mee}
\alias{ci_prop_diff_mee}
\title{Mee Confidence Interval for Difference in Proportions}
\usage{
ci_prop_diff_mee(x, by, conf.level = 0.95, delta = NULL, data = NULL)
}
\arguments{
\item{x}{(\code{binary}/\code{numeric}/\code{logical})\cr
vector of a binary values, i.e. a logical vector, or numeric with values \code{c(0, 1)}}

\item{by}{(\code{string}) \cr A character or factor vector with exactly two unique levels
identifying the two groups to compare. Can also be a column name if a data
frame provided in the \code{data} argument.}

\item{conf.level}{(\verb{scalar numeric}) \cr a scalar in (0,1) indicating the confidence level. Default is 0.95}

\item{delta}{(\code{numeric}) \cr Optionally a single number or a vector of
numbers between -1 and 1 (not inclusive) to set the difference between two
groups under the null hypothesis. If provided, the function returns the
test statistic and p-value under the \code{delta}
hypothesis.}

\item{data}{(\code{data.frame}) \cr Optional data frame containing the variables specified in \code{x} and \code{by}.}
}
\value{
An object containing the following components:

\item{n}{The number of responses for each group}
\item{N}{The total number in each group}
\item{estimate}{The point estimate of the difference in proportions (p1-p2)}
\item{conf.low}{Lower bound of the confidence interval}
\item{conf.high}{Upper bound of the confidence interval}
\item{conf.level}{The confidence level used}
\item{method}{Mee Confidence Interval}
}
\description{
Mee Confidence Interval for Difference in Proportions
}
\details{
The confidence interval is calculated by \eqn{\theta^* \pm w} where:

\deqn{\theta^* = \frac{(\hat{p}_1 - \hat{p}_2) + z^2v(1-2\hat{\psi})}{1+z^2u}}
where
\deqn{w = \frac{z}{1+z^2u}\sqrt{u\{4\hat{\psi}(1-\hat{\psi})-(\hat{p}_1 - \hat{p}_2)^2\}+2v(1-2\hat{\psi})(\hat{p}_1-\hat{p}_2)
+4z^2v^2(1-2\hat{\psi})^2
}}
\deqn{\hat{\psi} = \frac{1}{2}\left(\frac{x_1 + 1/2}{n_1+1}+\frac{x_2 + 1/2}{n_2+1}\right)}
\deqn{u = \frac{1/n_1 + 1/n_2}{4}}
\deqn{v = \frac{1/n_1 - 1/n_2}{4}}
}
\examples{
responses <- expand(c(9, 3), c(10, 10))
arm <- rep(c("treat", "control"), times = c(10, 10))

# Calculate 95\% confidence interval for difference in proportions
ci_prop_diff_mee(x = responses, by = arm)
}
\references{
\href{https://www.lexjansen.com/wuss/2016/127_Final_Paper_PDF.pdf}{Constructing Confidence Intervals for the Differences of Binomial Proportions in SAS}
}
