% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation4R.R
\name{conversation4R}
\alias{conversation4R}
\title{Conversation Interface for R}
\usage{
conversation4R(
  message,
  api_key = Sys.getenv("OPENAI_API_KEY"),
  system_set = "",
  ConversationBufferWindowMemory_k = 2,
  Model = "gpt-4o-mini",
  language = "English",
  initialization = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{message}{A string containing the message to be sent to the model.}

\item{api_key}{A string containing the OpenAI API key. Default is retrieved from the system environment variable "OPENAI_API_KEY".}

\item{system_set}{A string containing the system_set for the conversation. Default is an empty string.}

\item{ConversationBufferWindowMemory_k}{An integer representing the conversation buffer window memory. Default is 2.}

\item{Model}{A string representing the model to be used. Default is "gpt-4o-mini".}

\item{language}{A string representing the language to be used in the conversation. Default is "English".}

\item{initialization}{A logical flag to initialize a new conversation. Default is FALSE.}

\item{verbose}{A logical flag to print the conversation. Default is TRUE.}
}
\value{
Prints the conversation if verbose is TRUE. No return value.
}
\description{
Interface to communicate with OpenAI's models using R, maintaining a conversation history and allowing for initialization of a new conversation.
}
\details{
Conversation Interface for R with OpenAI

This function provides an interface to communicate with OpenAI's models using R. It maintains a conversation history and allows for initialization of a new conversation.
}
\examples{
\dontrun{
conversation4R(message = "Hello, OpenAI!",
               api_key = "your_api_key_here",
               language = "English",
               initialization = TRUE)
}
}
\author{
Satoshi Kume
}
