% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{nodes}
\alias{nodes}
\alias{vertices}
\alias{V}
\title{Get nodes or edges of a \code{caugi}}
\usage{
nodes(cg)

vertices(cg)

V(cg)
}
\arguments{
\item{cg}{A \code{caugi} object.}
}
\value{
A \code{data.table} with a \code{name} column.
}
\description{
Get nodes or edges of a \code{caugi}
}
\examples{
cg <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  D,
  class = "DAG"
)
nodes(cg) # returns the data.table with nodes A, B, C, D

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
