% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{is_pdag}
\alias{is_pdag}
\title{Is the \code{caugi} graph a PDAG?}
\usage{
is_pdag(cg, force_check = FALSE)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{force_check}{Logical; if \code{TRUE}, the function will test if the graph is
a PDAG, if \code{FALSE} (default), it will look at the graph class and match
it, if possible.}
}
\value{
A logical value indicating whether the graph is a PDAG.
}
\description{
Checks if the given \code{caugi} graph is a
Partially Directed Acyclic Graph (PDAG).
}
\examples{
cg_dag_class <- caugi(
  A \%-->\% B,
  class = "DAG"
)
is_pdag(cg_dag_class) # TRUE
cg_dag_but_pdag_class <- caugi(
  A \%-->\% B,
  class = "PDAG"
)
is_pdag(cg_dag_but_pdag_class) # TRUE
cg_cyclic <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  C \%-->\% A,
  D \%---\% A,
  class = "UNKNOWN",
  simple = FALSE
)
is_pdag(cg_cyclic) # FALSE

cg_undirected <- caugi(
  A \%---\% B,
  class = "UNKNOWN"
)
is_pdag(cg_undirected) # TRUE

cg_pag <- caugi(
  A \%o->\% B,
  class = "UNKNOWN"
)
is_pdag(cg_pag) # FALSE

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
