% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustment.R
\name{is_valid_backdoor}
\alias{is_valid_backdoor}
\title{Is a backdoor set valid?}
\usage{
is_valid_backdoor(
  cg,
  X = NULL,
  Y = NULL,
  Z = NULL,
  X_index = NULL,
  Y_index = NULL,
  Z_index = NULL
)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{X, Y}{Single node names.}

\item{Z}{Optional node set for conditioning}

\item{X_index, Y_index, Z_index}{Optional 1-based indices.}
}
\value{
Logical value indicating if backdoor is valid or not.
}
\description{
Checks whether \code{Z} is a valid backdoor adjustment set for
\verb{X --> Y}.
}
\examples{
cg <- caugi(
  C \%-->\% X,
  X \%-->\% F,
  X \%-->\% D,
  A \%-->\% X,
  A \%-->\% K,
  K \%-->\% Y,
  D \%-->\% Y,
  D \%-->\% G,
  Y \%-->\% H,
  class = "DAG"
)

is_valid_backdoor(cg, X = "X", Y = "Y", Z = NULL) # FALSE
is_valid_backdoor(cg, X = "X", Y = "Y", Z = "K") # TRUE
is_valid_backdoor(cg, X = "X", Y = "Y", Z = c("A", "C")) # TRUE

}
\seealso{
Other adjustment: 
\code{\link{adjustment_set}()},
\code{\link{all_backdoor_sets}()},
\code{\link{d_separated}()}
}
\concept{adjustment}
