% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_pegel_online.R
\name{pegel_online_stations}
\alias{pegel_online_stations}
\title{List Pegel-Online stations}
\usage{
pegel_online_stations(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with station metadata.
}
\description{
List Pegel-Online stations
}
\details{
The Pegel-Online API provides water level station metadata. Use query
parameters to filter stations by water, ids, or location. Official docs:
https://pegel-online.api.bund.dev.
}
\examples{
\dontrun{
pegel_online_stations(params = list(limit = 5))
}

}
\seealso{
\code{\link[=pegel_online_station]{pegel_online_station()}} for a single station and
\code{\link[=pegel_online_measurements]{pegel_online_measurements()}} for time series values.
}
