% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed_list_feed.R
\name{bs_get_list_feed}
\alias{bs_get_list_feed}
\title{Retrieve recent posts from actors in a list}
\usage{
bs_get_list_feed(
  list,
  cursor = NULL,
  limit = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{list}{Character vector, length 1. Reference of the list record to get.}

\item{cursor}{Character, length 1. A cursor property from a prior response. Default: \code{NULL}.}

\item{limit}{Integer. Number of records to request. If over \code{100}, multiple requests are made.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of likes
}
\description{
Retrieve recent posts from actors in a list
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/getListFeed.json}{feed/getListFeed.json (2025-03-20)}
}

\section{Function introduced}{

\code{v0.3.0} (2025-03-20)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_get_list_feed('at://did:plc:ragtjsm2j2vknwkz3zp4oxrd/app.bsky.graph.list/3kmokjyuflk2g')
\dontshow{\}) # examplesIf}
}
\concept{feed}
