% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{condition_task}
\alias{condition_task}
\title{Condition Task}
\usage{
condition_task(
  left,
  right,
  op = c("EQUAL_TO", "GREATER_THAN", "GREATER_THAN_OR_EQUAL", "LESS_THAN",
    "LESS_THAN_OR_EQUAL", "NOT_EQUAL")
)
}
\arguments{
\item{left}{Left operand of the condition task. Either a string value or a
job state or parameter reference.}

\item{right}{Right operand of the condition task. Either a string value or a
job state or parameter reference.}

\item{op}{Operator, one of \code{"EQUAL_TO"}, \code{"GREATER_THAN"},
\code{"GREATER_THAN_OR_EQUAL"}, \code{"LESS_THAN"}, \code{"LESS_THAN_OR_EQUAL"}, \code{"NOT_EQUAL"}}
}
\description{
Condition Task
}
\details{
The task evaluates a condition that can be used to control the execution of
other tasks when the condition_task field is present. The condition task does
not require a cluster to execute and does not support retries or notifications.
}
\seealso{
Other Task Objects: 
\code{\link{email_notifications}()},
\code{\link{for_each_task}()},
\code{\link{libraries}()},
\code{\link{new_cluster}()},
\code{\link{notebook_task}()},
\code{\link{pipeline_task}()},
\code{\link{python_wheel_task}()},
\code{\link{run_job_task}()},
\code{\link{spark_jar_task}()},
\code{\link{spark_python_task}()},
\code{\link{spark_submit_task}()},
\code{\link{sql_file_task}()},
\code{\link{sql_query_task}()}
}
\concept{Task Objects}
