% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_iris.R
\name{read_iris}
\alias{read_iris}
\title{Read 13C data from IRIS/Wagner Analysen}
\usage{
read_iris(filename = NULL, text = NULL)
}
\arguments{
\item{filename}{name of IRIS/Wagner file in composite format}

\item{text}{alternatively, text can be given as string}
}
\value{
List of class \code{\link{breathtest_data}} with 
\code{file_name, patient_name, patient_first_name,
test, identifikation}, and data frame \code{data} with \code{time}
and \code{dob}
}
\description{
Reads composite files with 13C data from IRIS/Wagner Analysen.
The composite files start as follows:
\preformatted{
"Testergebnis"
"Nummer","1330"
"Datum","10.10.2013"
"Testart"}
}
\examples{
filename = btcore_file("IrisMulti.TXT")
cat(readLines(filename, n = 10, encoding = "latin1"), sep="\n")
#
iris_data = read_iris(filename)
str(iris_data)
}
