% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_breathtestfit.R
\name{coef.breathtestfit}
\alias{coef.breathtestfit}
\title{S3 coef and summary for breathtestfit}
\usage{
\method{coef}{breathtestfit}(object, ...)
}
\arguments{
\item{object}{of class \code{breathtestfit}, as returned by \code{\link{nls_fit}} or 
\code{\link{nlme_fit}}}

\item{...}{other parameters passed to methods}
}
\description{
Function \code{coef} extracts the estimates such as t50, 
tlag, from fitted 13C beta  exponential models. The result is the same 
as \code{fit$coef}, but without
column \code{stat}, which always is \code{"estimate"} for \code{\link{nls_fit}}
and \code{\link{nlme_fit}}. 

The \code{summary} method only extracts \code{t50} by the Maes/Ghoos method
}
\examples{
# Generate simulated data
data = cleanup_data(simulate_breathtest_data())
# Fit with the population method
fit = nlme_fit(data)
# All coefficients in the long form
coef(fit)
# Access coefficients directly
fit$coef
# Only t50 by Maes/Ghoos
# Can also be used with stan fit (slow!)
\dontrun{
if (require("breathteststan")) {
  fit = stan_fit(data, iter = 300, chain = 1)
  coef(fit)
  # We get quantiles here in key/value format
  unique(fit$coef$stat)
}
}
}
