% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bes_g_gao.R
\name{bes_g_gao}
\alias{bes_g_gao}
\title{Boltzmann entropy of a landscape gradient}
\usage{
bes_g_gao(
  x,
  method = "aggregation",
  na_adjust = TRUE,
  base = "log10",
  relative = FALSE
)
}
\arguments{
\item{x}{SpatRaster, stars, RasterLayer, RasterStack, RasterBrick, matrix, or array.}

\item{method}{A method used. Either "hierarchy" for
the hierarchy-based method (Gao et al., 2017) or "aggregation" (default)
for the aggregation-based method (Gao et al., 2019).}

\item{na_adjust}{Should the output value be adjusted to the proportion of not missing cells? Either TRUE (default) or FALSE}

\item{base}{A logarithm base ("log", "log2" or "log10").}

\item{relative}{Should a relative or absolute entropy be calculated? TRUE or FALSE (default).}
}
\value{
A tibble
}
\description{
Calculates the Boltzmann entropy of a landscape gradient by Gao (2017, 2019)
}
\details{
The method for computing the Boltzmann entropy of a landscape
gradient works on integer values that are either positive or equals to zero.
This function automatically rounds values to the nearest integer value
(rounding halfway cases away from zero) and negative values are shifted to
positive values.
}
\examples{
library(terra)
library(bespatial)
gradient = rast(system.file("raster/gradient.tif", package = "bespatial"))
gg1 = bes_g_gao(gradient)
plot(gradient, main = round(gg1$value, 2))
}
\references{
Gao, Peichao, Hong Zhang, and Zhilin Li. "A hierarchy-based
solution to calculate the configurational entropy of landscape gradients."
Landscape Ecology 32.6 (2017): 1133-1146.

Gao, Peichao, Hong Zhang, and Zhilin Li. "An efficient
analytical method for computing the Boltzmann entropy of a landscape
gradient." Transactions in GIS (2018).

Gao, Peichao and Zhilin Li. "Aggregation-based method
for computing absolute Boltzmann entropy of landscape gradient
with full thermodynamic consistency"
Landscape Ecology (2019)
}
