% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixmod_gibbs_functions.R
\name{get.llk.mixmod}
\alias{get.llk.mixmod}
\title{Internal function to calculate the log-likelihood for iteration of mixture model}
\usage{
get.llk.mixmod(phi, theta, ndata.types, dat, nobs, nmaxclust)
}
\arguments{
\item{phi}{A list of proportion estimates that characterize distributions
(bins) for each data stream and possible behavioral state.}

\item{theta}{numeric. A vector of values that sum to one.}

\item{ndata.types}{numeric. The number of data streams being analyzed.}

\item{dat}{A data frame containing only columns of the discretized data
streams for all observations.}

\item{nobs}{numeric. The total number of rows in the dataset.}

\item{nmaxclust}{numeric. A single number indicating the maximum number of
clusters to test.}
}
\value{
A numeric value of the log-likelihood based upon the current values
  for \emph{phi} and \emph{theta}.
}
\description{
Calculates the log-likelihood of the mixture model based on estimates for
\emph{theta} and \emph{phi}.
}
