% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_evaluation.R
\name{get_evaluation.cpp}
\alias{get_evaluation.cpp}
\title{Evaluate a Basket Trial with the Calibrated Power Prior
Design}
\usage{
\method{get_evaluation}{cpp}(design, n, r, lambda, level = 0.95, tune_a, tune_b, ...)
}
\arguments{
\item{design}{An object of class \code{cpp}.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{r}{Vector of responses.}

\item{lambda}{The posterior probability threshold.}

\item{level}{Level of the credibility intervals.}

\item{tune_a}{First tuning parameter that determines the amount of borrowing
based on pairwise similarity between baskets.}

\item{tune_b}{Second tuning parameter that determines the amount of borrowing
based on pairwise similarity between baskets.}

\item{...}{Further arguments.}
}
\value{
A list containing the point estimates of the basket-specific response rates and the
posterior probabilities that the estimated response rates are above a specified threshold p0.
}
\description{
Evaluate a Basket Trial with the Calibrated Power Prior
Design
}
\examples{
design <- setup_cpp(k = 3, p0 = 0.2)

# Equal sample sizes
get_evaluation(design = design, n = 20, r = c(10, 15, 5),
  lambda = 0.95, tune_a = 1, tune_b = 1, iter = 100)

# Unequal sample sizes
get_evaluation(design = design, n = c(15, 20, 25), r = c(10, 15, 17),
  lambda = 0.95, tune_a = 1, tune_b = 1, iter = 100)
}
