% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting_triangle-class.R
\name{new_reporting_triangle}
\alias{new_reporting_triangle}
\title{Class constructor for \code{reporting_triangle} objects}
\usage{
new_reporting_triangle(reporting_triangle_matrix, reference_dates, delays_unit)
}
\arguments{
\item{reporting_triangle_matrix}{Matrix of reporting triangle where rows
are reference times, columns are delays, and entries are incident counts.}

\item{reference_dates}{Vector of Date objects indicating the reference dates
corresponding to each row of the matrix.}

\item{delays_unit}{Character string specifying the temporal granularity of
the delays. Options are \code{"days"}, \code{"weeks"}, \code{"months"}, \code{"years"}.
Default is \code{"days"}.}
}
\value{
An object of class \link{reporting_triangle}
}
\description{
Creates a new reporting_triangle object from a matrix.
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
