% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting_triangle-getters.R
\name{get_max_delay}
\alias{get_max_delay}
\title{Get maximum delay from reporting_triangle}
\usage{
get_max_delay(x, non_zero = FALSE)
}
\arguments{
\item{x}{A reporting_triangle object}

\item{non_zero}{Logical. If TRUE, returns the maximum delay where at least
one observation is non-zero. Useful for identifying the actual extent of
the delay distribution. Default FALSE.}
}
\value{
Maximum delay (integer), or -1 if all zero when non_zero = TRUE
}
\description{
Get maximum delay from reporting_triangle
}
\examples{
# Get maximum delay from triangle structure
max_delay <- get_max_delay(example_reporting_triangle)
max_delay

# Get maximum delay with non-zero observations
max_delay_nz <- get_max_delay(example_reporting_triangle, non_zero = TRUE)
max_delay_nz
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
