% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baggr-package.R
\docType{package}
\name{baggr-package}
\alias{baggr-package}
\title{baggr - a package for Bayesian meta-analysis}
\description{
This is \emph{baggr} (pronounced as \emph{bagger} or \emph{badger}), a Bayesian meta-analysis
package for R that uses \href{https://mc-stan.org/}{Stan} to fit the models.
\emph{Baggr} is intended to be user-friendly and transparent so that
it's easier to understand the models you are building and criticise them.
}
\details{
\emph{Baggr} package provides a suite of models that work with both summary data and full data sets,
to synthesise evidence collected from different groups, contexts or time periods.
The \link{baggr} command automatically detects the data type and, by default, fits a partial
pooling model (which some users may know as random effects models)
with weakly informative priors by calling \href{https://mc-stan.org/}{Stan} to carry
out Bayesian inference. Modelling of variances or quantiles, standardisation and
transformation of data are also possible.
}
\section{Getting help}{


This is only a simple package help file.
For documentation of the main function for conducting analyses see \link{baggr}.
For description of models, data types and priors available in the package,
try the built-in vignette (\code{vignette("baggr")}).
}

\references{
Stan Development Team (2024). RStan: the R interface to Stan. R package version 2.32.6. https://mc-stan.org
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/wwiecek/baggr}
  \item Report bugs at \url{https://github.com/wwiecek/baggr/issues}
}

}
\author{
\strong{Maintainer}: Witold Wiecek \email{witold.wiecek@gmail.com}

Authors:
\itemize{
  \item Rachael Meager
}

Other contributors:
\itemize{
  \item Brice Green (loo_compare, many visuals) [contributor]
  \item Danny Toomey (many bug fixes) [contributor]
  \item Trustees of Columbia University (package skeleton) [copyright holder]
}

}
\keyword{internal}
