% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_cursor_to_bytes}
\alias{am_cursor_to_bytes}
\title{Serialize a cursor to bytes}
\usage{
am_cursor_to_bytes(cursor)
}
\arguments{
\item{cursor}{An \code{am_cursor} object created by \code{\link[=am_cursor]{am_cursor()}}}
}
\value{
A raw vector containing the serialized cursor
}
\description{
Converts a cursor to a raw vector representation that can be persisted
and later restored with \code{\link[=am_cursor_from_bytes]{am_cursor_from_bytes()}}. This enables saving
cursor positions across R sessions.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

cursor <- am_cursor(text_obj, 5)
bytes <- am_cursor_to_bytes(cursor)
bytes

# Restore cursor later
restored <- am_cursor_from_bytes(bytes, text_obj)
am_cursor_position(restored)  # 5

am_close(doc)

}
\seealso{
\code{\link[=am_cursor_from_bytes]{am_cursor_from_bytes()}}, \code{\link[=am_cursor_to_string]{am_cursor_to_string()}}
}
