% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz.R
\name{viz.set}
\alias{viz.set}
\title{Set Visualization Settings}
\usage{
viz.set(
  theme = NULL,
  export_graphics = NULL,
  export_path = NULL,
  graph_scale = NULL
)
}
\arguments{
\item{theme}{\emph{[character, optional]} Color theme. Use \code{viz.themes()} to see available themes.}

\item{export_graphics}{\emph{[logical, optional]} If TRUE, export plots to files.}

\item{export_path}{\emph{[character, optional]} Directory path for exported plots.}

\item{graph_scale}{\emph{[numeric, optional]} Scaling factor for exported graphics.
Values > 1 increase resolution.}
}
\value{
Previous settings (invisibly), enabling easy restoration.
}
\description{
Set visualization options for the current session.
Only provided arguments are changed; others remain unchanged.
}
\examples{
\dontrun{
# Change theme
viz.set(theme = "purple")

# Enable export with custom path
viz.set(export_graphics = TRUE, export_path = "./output/plots")

# Save and restore settings
prev <- viz.set(theme = "red")
# ... do work ...
do.call(viz.set, prev)
}
}
