% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alsi.R
\name{alsi}
\alias{alsi}
\title{Compute Aggregated Latent Space Index (ALSI)}
\usage{
alsi(Fmat, eig, K)
}
\arguments{
\item{Fmat}{Matrix of row principal coordinates (N x K or larger)}

\item{eig}{Vector of eigenvalues (inertias)}

\item{K}{Integer, number of dimensions to aggregate}
}
\value{
S3 object of class \code{alsi} containing:
  \item{alpha}{Numeric vector of ALSI values (length N), representing
    each individual's variance-weighted distance from the centroid 
    in the retained MCA subspace}
  \item{w}{Variance weights (length K), computed as the proportion of 
    retained inertia for each dimension}
  \item{alpha_vec}{Aggregated direction vector (length K), equal to 
    sqrt(w), used for projecting category coordinates}
  \item{K}{Number of dimensions used in aggregation}
}
\description{
Calculates ALSI as a variance-weighted Euclidean norm of row principal
coordinates within a retained K-dimensional MCA subspace.
}
\examples{
# Create example data
set.seed(123)
Fmat <- matrix(rnorm(100 * 4), nrow = 100, ncol = 4)
eig <- c(0.5, 0.3, 0.15, 0.05)

# Compute ALSI
a <- alsi(Fmat, eig, K = 3)
print(a)
hist(a$alpha, main = "Distribution of ALSI")
}
