% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_get_pf.R
\name{av_get_pf}
\alias{av_get_pf}
\title{Get financial data from the Alpha Vantage API}
\usage{
av_get_pf(
  symbol,
  av_fun,
  symbolvarnm = "symbol",
  dfonerror = TRUE,
  melted = "default",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{symbol}{A character string of an appropriate stock, fund, or currency
See parameter "symbol" in \href{https://www.alphavantage.co/documentation/}{Alpha Vantage API documentation}.}

\item{av_fun}{A character string matching an appropriate Alpha Vantage "function".
See parameter "function" in \href{https://www.alphavantage.co/documentation/}{Alpha Vantage API documentation}.}

\item{symbolvarnm}{(default: \code{symbol}) Variable name which has the \code{symbol} requested.  Set to a blank string if not wanted.}

\item{dfonerror}{(default: TRUE) Return an empty data.table when any error occurs}

\item{melted}{(default: "default") String specifying when to melt, "default" is chosen by the package, "TRUE|always" always melt, "FALSE|never" never melts}

\item{verbose}{(default: FALSE) Print debug information helpful for errors.  Also copies full url to clipboard.}

\item{...}{Additional parameters or overrides passed to the Alpha Vantage API.
For a list of parameters, visit the \href{https://www.alphavantage.co/documentation/}{Alpha Vantage API documentation}.}
}
\value{
Returns a data.table with results dependent on the function called.
Mixed data is returned as a melted data.table, possibly with nested data.frames.  Time series are returned as data.tables.
}
\description{
Interface to alphavantage API.
}
\details{
\strong{The \code{av_fun} argument replaces the API parameter “function”} because function is a reserved name in R. All other arguments match the Alpha Vantage API parameters.

\strong{There is no need to specify the \code{apikey}, \code{datatype}, \code{outputsize} or \code{entitlement} parameters} as arguments to av_get_pf(). Before using, you must set the API key using av_api_key("YOUR_API_KEY"). \code{outputsize} defaults to "full" unless overridden with "compact in \code{...}."

\strong{Required parameters other than \code{symbol}} must be passed as named arguments via \code{...}.

\strong{Optional parameters have defaults} which can be obtained  by calling  \code{\link[=av_funhelp]{av_funhelp()}} and overridden via \code{...}.

\strong{There is no need to specify the datatype parameter} as an argument to \code{\link[=av_get_pf]{av_get_pf()}}. The function will return a data.table.

\strong{ForEx "FROM/TO" symbol details.} FOREX symbols in the \code{av_get_pf()} function are
supplied in \code{"FROM/TO"} format, which are then parsed in the Alpha Vantage API
into \code{from_currency} and \code{to_currency} API parameters. Usage example:
\code{av_get_pf("USD/BRL", "FX_DAILY")}
}
\examples{
\dontrun{
av_api_key("YOUR_API_KEY")
av_api_key("YOUR_API_KEY","delayed") # if you have such access

# example code

# ---- 1.0 SINGLE NAME EQUITY SUMMARY INFORMATION AND SEARCH ----

av_get_pf("IBM","OVERVIEW") |> str()

av_get_pf("EWZ","ETF_PROFILE")
av_get_pf("EWZ","ETF_PROFILE") |> av_extract_df("holdings")

av_get_pf("","SYMBOL_SEARCH",keywords="COMMERCE")

# ---- 2.0 MARKET QUOTES  ----

av_get_pf("IBM","GLOBAL_QUOTE")

av_get_pf("USD/BRL","CURRENCY_EXCHANGE_RATE") |> av_extract_fx()

av_get_pf(c("ORCL","IBM","EWZ","ARGT"),"REALTIME_BULK_QUOTES",melt=FALSE)
# Note you need advanced permissioning for REALTIME_BULK_QUOTES

# ---- 3.0 SINGLE NAME HISTORICAL DATA  ----

av_get_pf("IBM","TIME_SERIES_DAILY")

av_get_pf("IBM","TIME_SERIES_INTRADAY")

# ---- 4.0 MARKET PRICING DATA  ----

av_get_pf("","MARKET_STATUS")  |> av_extract_df()

av_get_pf("","TOP_GAINERS_LOSERS") |> av_extract_df("top_losers")

av_get_pf("","TREASURY_YIELD",maturity='7year')

 # ---- 4.0 SINGLE NAME NON-PRICING DATA  ----

av_get_pf("IBM","DIVIDENDS")

av_get_pf("IBM","EARNINGS")  |> av_extract_df("quarter",melt=TRUE)

av_get_pf("IBM","NEWS_SENTIMENT") |> av_extract_df("feed")

av_get_pf("IBM","EARNINGS_CALL_TRANSCRIPT",quarter="2024Q3")  |> av_extract_df("transcript")
 # Note that quarter is a required parameter, not specifying will throw an error

 # ---- 5.0 SINGLE NAME OPTION PRICING DATA  ----

av_get_pf("IBM","HISTORICAL_OPTIONS") |> av_grep_opts("F,M,put",mindays=2)

# ---- 6.0 TECHNICAL INDICATORS  ----

av_funhelp("SMA")  # Shows parameters and defaults chosen by this package.
av_get_pf("IBM","SMA",time_period=20)

# ---- 7.0 WINDOW ANALYTICS  ----

av_get_pf(c("ORCL","IBM","EWZ","ARGT"),"ANALYTICS_FIXED_WINDOW",verbose=TRUE) |>
            av_extract_analytics(separate_vars=TRUE)
}

}
\seealso{
\code{\link[=av_api_key]{av_api_key()}}, \code{\link[=av_extract_df]{av_extract_df()}}, \code{\link[=av_extract_fx]{av_extract_fx()}}, \code{\link[=av_grep_opts]{av_grep_opts()}},\code{\link[=av_funhelp]{av_funhelp()}}
}
