% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fiftystates.R
\name{alarm_50state}
\alias{alarm_50state}
\alias{alarm_50state_map}
\alias{alarm_50state_plans}
\alias{alarm_50state_stats}
\alias{alarm_50state_doc}
\title{Download maps and plans from the 50-State Simulation Project}
\usage{
alarm_50state_map(state, year = 2020, refresh = FALSE)

alarm_50state_plans(
  state,
  stats = TRUE,
  year = 2020,
  refresh = FALSE,
  compress = "xz"
)

alarm_50state_stats(state, year = 2020, refresh = FALSE)

alarm_50state_doc(state, year = 2020)
}
\arguments{
\item{state}{A state name, abbreviation, FIPS code, or ANSI code.}

\item{year}{The redistricting cycle to download. Currently only \code{2020} and \code{2010} are available.}

\item{refresh}{If \code{TRUE}, ignore the cache and download again.}

\item{stats}{If \code{TRUE} (the default), download summary statistics for each plan.}

\item{compress}{The compression level used for caching \link[redist:redist_plans]{redist_plans} objects.}
}
\value{
For \code{alarm_50state_map()}, a \link[redist:redist_map]{redist_map}. For
\code{alarm_50state_plans()}, a \link[redist:redist_plans]{redist_plans}. For
\code{alarm_50state_doc()}, invisibly returns the path to the HTML documentation,
and also loads an HTML file into the viewer or web browser.
For \code{alarm_50state_stats()}, a \link[dplyr:reexports]{tibble}.
}
\description{
These functions will download \link[redist:redist_map]{redist_map} and
\link[redist:redist_plans]{redist_plans} objects for the 50-State Simulation
Project from the ALARM Project's Dataverse. \code{alarm_50state_doc()} will
download documentation for a particular state and show it in a browser.
\code{alarm_50state_stats} will download just the summary statistics for a state.
}
\details{
Every decade following the Census, states and municipalities must redraw
districts for Congress, state houses, city councils, and more. The goal of
the 50-State Simulation Project is to enable researchers, practitioners, and
the general public to use cutting-edge redistricting simulation analysis to
evaluate enacted congressional districts.

Evaluating a redistricting plan requires analysts to take into account each
state’s redistricting rules and particular political geography. Comparing the
partisan bias of a plan for Texas with the bias of a plan for New York, for
example, is likely misleading. Comparing a state’s current plan to a past
plan is also problematic because of demographic and political changes over
time. Redistricting simulations generate an ensemble of alternative
redistricting plans within a given state which are tailored to its
redistricting rules. Unlike traditional evaluation methods, therefore,
simulations are able to directly account for the state’s political geography
and redistricting criteria.
}
\examples{
\dontshow{if (Sys.getenv("DATAVERSE_KEY") != '') withAutoprint(\{ # examplesIf}

# requires Harvard Dataverse API key
alarm_50state_map("WA")
alarm_50state_plans("WA", stats = FALSE)
alarm_50state_stats("WA")
alarm_50state_doc("WA")

map <- alarm_50state_map("WY")
pl <- alarm_50state_plans("WY")
\dontshow{\}) # examplesIf}
}
